﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Transactions;
using System.ComponentModel;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.DAL;

namespace AZVIC.Ei8htPOS.BAL
{
    [DataObjectAttribute()]
    public static class ProductColorBL
    {
        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static ProductColor GetItem(Guid productColorID, string keyword)
        {
            return ProductColorDB.GetItem(productColorID, Utilities.ValidationUtility.ReplaceWildcardCharactersForSQL(keyword));
        }

        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static List<ProductColor> GetList(Guid productColorID, string keyword)
        {
            return ProductColorDB.GetList(productColorID, Utilities.ValidationUtility.ReplaceWildcardCharactersForSQL(keyword));
        }

        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static DataTable GetDataTable(Guid productColorID, string keyword)
        {
            return ProductColorDB.GetDataTable(productColorID, Utilities.ValidationUtility.ReplaceWildcardCharactersForSQL(keyword));
        }

        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static DataSet GetDataSet(Guid productColorID, string keyword)
        {
            return ProductColorDB.GetDataSet(productColorID, Utilities.ValidationUtility.ReplaceWildcardCharactersForSQL(keyword));
        }

        [DataObjectMethod(DataObjectMethodType.Update, true)]
        public static bool Save(ProductColor myProductColor)
        {
            using (TransactionScope myTransactionScope = new TransactionScope())
            {
                ProductColorDB.Save(myProductColor);

                myTransactionScope.Complete();
                return true;
            }
        }
    }
}
